#!/usr/bin/sh

### This script is used to handle the timezone for docker containers on CentOS ###

# Directory where the timezone file will exists
dir_for_timezone='/opt/grs/runtime'

# The timezone file, which will be used to mount to the file inside docker containers 
timezone_for_docker_container='/opt/grs/runtime/timezone_for_docker_container'

# Create the directory, if not exists
if [ ! -d "$dir_for_timezone" ]; then
    sudo mkdir -p "$dir_for_timezone"
fi

# Permissions for the directory
sudo chown -R gradmin:gradmin "$dir_for_timezone"

# Create the file, if not exists
if [ ! -f "$timezone_for_docker_container" ]; then
     sudo touch "$timezone_for_docker_container"
fi

# Permissions for the file
sudo chown gradmin:gradmin "$timezone_for_docker_container"

# Detect the system timezone and enter it inside the file
TZ=`realpath --relative-to /usr/share/zoneinfo /etc/localtime`
echo $TZ > "$timezone_for_docker_container"
