<?php
require_once('/var/www/u2f/src/u2flib_server/U2F.php');
require_once '/usr/share/ykropval/Yubico_YkMap.php';
require_once '/usr/share/ykropval/ykropval-common.php';

if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == "")
{
    $redirect = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    header("Location: $redirect");
}


$scheme = isset($_SERVER['HTTPS']) ? "https://" : "http://";
//$u2f = new u2flib_server\U2F($scheme . $_SERVER['HTTP_HOST']);
$u2f = new u2flib_server\U2F("https://" . $_SERVER['HTTP_HOST']);

//header('X-Frame-Options: SAMEORIGIN');

if (isset($_POST['startAuthenticate']))
{
    $userName = strtolower($_POST['username']);
    $countDomainsFrmDb = countDomains(true);
    if ($countDomainsFrmDb < 1)
    {
        insertIntoAuditlog("FIDO U2F token authentication failed- domain not found for user '$userName'", "ERROR");
    }
    else
    {
        if ($countDomainsFrmDb > 1 && !stripos($userName, "@") && !getDefaultDomain() && !getUserDomain($userName))
        {
            insertIntoAuditlog("FIDO U2F token authentication failed- username '$userName' not entered in username@domain format", "ERROR");
        }
        else
        {
            $user_domain = seperatUsersAndDomain($userName);
            if ($user_domain)
            {
                $userName = $user_domain[0] . "@" . $user_domain[1];

                $maxQueueId = getMaxQueueId($userName);
                if (!$maxQueueId)
                {
                    insertIntoAuditlog("FIDO U2F token authentication failed - no pending authentication session was found for user '$userName'", "ERROR");
                }
                else
                {
                    $result_temp = getUserQueueDetails($userName, $maxQueueId);

                    if ($result_temp['update_status'] == "registration_request")
                    {
                       $regs = file_get_contents("/assets/test1.json");

                       $regs = fixupArray(json_encode($regs));

                        list($data, $reqs) = $u2f->getRegisterData($regs);
                                   //echo "data: " . $data . " reqs: " . $reqs;
                        $request = json_encode($data);
                        $signs = json_encode($reqs);
                        $user = json_encode($_POST['username']);

                        echo json_encode(array('action' => 'start_registration', 'content' => array('request' => $request, 'signs' => $signs, 'user' => $user)));
                        exit;
                    }

                    if ($result_temp)
                    {
                        $result = urlencode($result_temp["token_assignment"]);
                        if (strtotime($result_temp["expires"]) > time())
                        {
                            $regs = trim(urldecode($result));
                            $regs1 = array(json_decode($regs));
                            $data = $u2f->getAuthenticateData($regs1);

                          //  $arr_of_auth_attr = array();
                            echo json_encode(array('action' => "start_authentication", 'content' => array('registrations' => $regs1, 'request' => $data, 'user' => $userName, 'maxQueueId' => $maxQueueId)));
                        }
                        else
                        {
                            insertIntoAuditlog("FIDO U2F token authentication failed- authentication session timed out for user '$userName'", "ERROR");
                        }
                    }
                    else
                    {
                        insertIntoAuditlog("FIDO U2F token authentication failed- token not found for user '$userName'", "ERROR");
                    }
                }
            }
            else
            {
                insertIntoAuditlog("FIDO U2F token authentication failed- user '$userName' not found", "ERROR");
            }
        }
    }
}
elseif ($_POST['doAuthenticate'])
{
    $reqs = json_decode($_POST['request']);
    $regs = json_decode($_POST['registrations']);
    try
    {
        $data = $u2f->doAuthenticate($reqs, $regs, json_decode($_POST['doAuthenticate']));
    }
    catch (Exception $e)
    {
        if (stripos($e->getMessage(), "Error code: 2") != 0)
        {
            $msg .= "invalid appId!";
            $msg = 2;
        }
        if (stripos($e->getMessage(), "Error code: 3") != 0)
        {
            $msg .= "client configuration is not supported!";
            $msg = 3;
        }
        if (stripos($e->getMessage(), "Error code: 4") != 0)
        {
            $msg .= "invalid security key!";
            $msg = 4;
        }
        if (stripos($e->getMessage(), "Error code: 5") != 0)
        {
            $msg .= "timed out!";
            $msg = 5;
        }
    }

    if (property_exists($data, 'counter'))
    {
        
        updateUserQueueStatus($_POST['user'], $_POST['maxId'], "successful");
        echo "auth = '" . $data->counter . "';\n";
        $userName_log = $_POST['user'];
        insertIntoAuditlog("FIDO U2F token authentication successful for user '$userName_log'", "LOG");
    }
    else
    {
        updateUserQueueStatus($_POST['user'], $_POST['maxId'], "failed");
        if (isset($msg))
        {
            switch ($msg)
            {
                case 2:
                    insertIntoAuditlog("FIDO U2F token authentication failed: invalid appId", "ERROR");
                    echo "error = '" . _("invalid appId!") . "';\n";
                    break;
                case 3:
                    insertIntoAuditlog("FIDO U2F token authentication failed: client configuration is not supported", "ERROR");
                    echo "error = '" . _("client configuration is not supported!") . "';\n";
                    break;
                case 4:
                    insertIntoAuditlog("FIDO U2F token authentication failed: invalid security key", "ERROR");
                    echo "error = '" . _("invalid security key!") . "';\n";
                    break;
                case 5:
                    insertIntoAuditlog("FIDO U2F token authentication failed: timed out", "ERROR");
                    echo "error = '" . _("timed out!") . "';\n";
                    break;
            }
        }
        else
        {
            echo "error = '" . $data->errorMessage . "';\n";
        }
    }
}

function fixupArray($data)
{

    $ret = array();
    $decoded = json_decode($data);

    
    foreach ($decoded as $d)
    {

        $ret[] = json_encode($d);
    }
    return $ret;
}
?>

