<?php
  
require_once('/var/www/u2f/src/u2flib_server/U2F.php');
require_once '/usr/share/ykropval/Yubico_YkMap.php';
require_once '/usr/share/ykropval/ykropval-common.php';

  $scheme = isset($_SERVER['HTTPS']) ? "https://" : "http://";
  $u2f = new u2flib_server\U2F($scheme . $_SERVER['HTTP_HOST']);
  $data = $u2f->doRegister(json_decode($_POST['request']), json_decode($_POST['doRegister']));
 
$username = $_POST['user_val'];

$countDomainsFrmDb = countDomains(true);
if ($countDomainsFrmDb < 1)
{
  insertIntoAuditlog("Failed to assign a token- domain not found for user '$username'", "ERROR");
  
}
else
{
    $userdomain = getUserDomain($username);
    $default_domain = getDefaultDomain();
    if ($countDomainsFrmDb > 1 && !stripos($username, "@") && !$default_domain && !$userdomain)
    { 
        insertIntoAuditlog("Failed to assign a token, username '$username' not entered in username@domain format", "ERROR");
    }
    else
    {
        $user_domain = seperatUsersAndDomain($username);
        if (!$user_domain)
        {
            insertIntoAuditlog("User '$username' not found", "ERROR");
        }
        else
        {
            $username = $user_domain[0] ."@". $user_domain[1];
        }
    
    }
}
  
  if(property_exists($data, 'errorMessage')) {
//    echo "error = '" . $data->errorMessage . "'\n";
    
    insertIntoAuditlog("Failed to register FIDO U2F token for user '$username', ".$data->errorMessage,"ERROR"); 
  } else {
    $ykmapAuth = &new Auth_Yubico_YkMap();
    $active = true;
    $resp = $ykmapAuth->add($username, urlencode(json_encode($data)), "u2f", $active);
    if ($resp === true) {
    //  echo "registration = '" . json_encode($data) . "';\n";

      insertIntoAuditlog("Successfully registered FIDO U2F token for user '$username'","LOG",'ss-01-01-1-0',$username,'U2F',$publicId);
      $maxQueueId = getMaxQueueId($username);
      updateUserQueueStatus($username, $maxQueueId, "successful");
    } else {
    //  echo "error = 'Unable to assign FIDO U2F Token to user'\n";i
   insertIntoAuditlog("Failed to register FIDO U2F token for user '$username'","ERROR");
    }
  }
  ?>
