
function registerUser(user, password, token_label, authApiUrl, callbackFunc, autoProvisioning = 0)
{	
    
    if(!isBrowserSupported())
    {
        success = 0;
        errMsg = 'Browser not supported';
        callbackFunc(success, errMsg, user);
    }

    var transaction_id;

    const regRequestOptions = {
        method: 'POST',
        body: JSON.stringify({"fido2Auth":"1","fido2Payload":{"operation": 'register-init',"username":user, "password":password,"token_label":token_label,"displayName":user, "autoProvisioning":autoProvisioning}}),
        headers:{ 'Content-Type': 'application/json'},
    };
	
	window.fetch(authApiUrl, regRequestOptions).then(function(response) {
        return response.json();

    }).then(function(json) {

        if (json.success === false) {

            if(json.response == 'sf enabled')
            {
                throw new Error('sf_enabled');
            }

            throw new Error(json.response);
        }

        transaction_id = json['transaction_id'];

        json.response.publicKey.challenge = base64URL_decode(json.response.publicKey.challenge);
        json.response.publicKey.user.id = base64URL_decode(json.response.publicKey.user.id);

        if(json.response.publicKey.excludeCredentials){
            json.response.publicKey.excludeCredentials.forEach(function (listItem) {
                listItem.id = base64URL_decode(listItem.id)
            });
        }

        return json.response;

    }).then(function(createCredentialArgs) {

        return navigator.credentials.create(createCredentialArgs);

    }).then(function(cred) {
        // convert to base64

        return {
            id: cred.id,
            rawId: cred.rawId ? base64URL_encode(cred.rawId) : null,
            response: {
               clientDataJSON: cred.response.clientDataJSON  ? base64URL_encode(cred.response.clientDataJSON) : null,
               attestationObject: cred.response.attestationObject ? base64URL_encode(cred.response.attestationObject) : null
            },
            type: cred.type
        };

    }).then(JSON.stringify).then(function(AuthenticatorAttestationResponse) {

        const regCompletionOptions = {
            method: 'POST',
            body: JSON.stringify({"fido2Auth":"1","fido2Payload":{'operation': 'register-complete','username': user,'authenticatorAttestationResponse':AuthenticatorAttestationResponse, 'transaction_id':transaction_id}}),
            headers:{ 'Content-Type': 'application/json'},
        };

        return window.fetch(authApiUrl, regCompletionOptions);
    
    }).then(function(response) {
        // convert to JSON    
        return response.json();

    }).then(function(json) {
        
        if (json.success) {
            success = 1;
            details = json.response || 'Registration Successful';

            callbackFunc(success, details, user);
        } else {
            throw new Error(json.response);
        }

    // catch errors
    }).catch(function(err) {
        success = 0;
        details = err.message || 'Unknown error occured';

        if(err.message == 'sf_enabled')
        {
            success = 1;
            details = 'Login successful with Single factor';
        }

        callbackFunc(success, details, user);
    });
}


function authenticateUser(user, password, authApiUrl, callbackFunc)
{
    if(!isBrowserSupported())
    {
        success = 0;
        errMsg = 'Browser not supported';
        callbackFunc(success, errMsg, user);
    }

    var transaction_id;

    const authRequestOptions = {
        method: 'POST',
        body: JSON.stringify({"fido2Auth":"1","fido2Payload":{"operation": 'authenticate-init',"username":user, "password":password}}),
        headers:{ 'Content-Type': 'application/json'},
    };

    window.fetch(authApiUrl, authRequestOptions).then(function(response) {
        return response.json();

    }).then(function(json) {  

        // error handling
        if (json.success === false) {
            if(json.response == 'sf enabled')
            {
                throw new Error('sf_enabled');
            }

	    if(json.msg){
                throw new Error(json.msg);
            }else{
                throw new Error(json.response);
            }
        }

        transaction_id = json['transaction_id'];

        // replace binary base64 data with ArrayBuffer
        json.response.challenge = base64URL_decode(json.response.challenge);
        
        if(json.response.allowCredentials){
            json.response.allowCredentials.forEach(function (listItem) {
                listItem.id = base64URL_decode(listItem.id)
            });
        }

        return json.response;

       // create credentials
    }).then(function(getCredentialArgs) {

        return navigator.credentials.get({publicKey:getCredentialArgs});

    }).then(function(cred) {

        return {
            rawId: cred.rawId ? base64URL_encode(cred.rawId) : null,
            id: cred.id,
            type: cred.type,
            response:{
                     clientDataJSON: cred.response.clientDataJSON  ? base64URL_encode(cred.response.clientDataJSON) : null,
                     authenticatorData: cred.response.authenticatorData ? base64URL_encode(cred.response.authenticatorData) : null,
                     signature : cred.response.signature ? base64URL_encode(cred.response.signature) : null,
                     userHandle: cred.response.userHandle ? base64URL_encode(cred.response.userHandle) : null
                     }
           };

    }).then(JSON.stringify).then(function(AuthenticatorAttestationResponse) {
            
        const authCompletionOptions = {
            method: 'POST',
            body: JSON.stringify({"fido2Auth":"1","fido2Payload":{'operation':'authenticate-complete', 'username': user,'authenticatorAttestationResponse':AuthenticatorAttestationResponse,'transaction_id':transaction_id}}),
            headers:{ 'Content-Type': 'application/json'},
        };

        return window.fetch(authApiUrl, authCompletionOptions);

    }).then(function(response) {

        // convert to json
        return response.json();

    }).then(function(json) {

       if (json.success) {
            success = 1;
            details = json.response || 'Login Successful';

            callbackFunc(success, details, user);
       } else {
           throw new Error(json.response);
       }

       // catch errors
    }).catch(function(err) {

            success = 0;
            details = err.message || 'Unknown error occured';  
            
            if(err.message == 'sf_enabled')
            {
                success = 1;
                details = 'Login successful with Single factor';
            }

            callbackFunc(success, details, user);
    });       
}

function isBrowserSupported()
{
    if (!window.fetch || !navigator.credentials || !navigator.credentials.create) {
        return false;
    }

    return true;

}

function base64URL_encode(buffer) 
{
  return btoa(Array.from(new Uint8Array(buffer)).map(val => {
    return String.fromCharCode(val);
  }).join('')).replace(/\+/g, '-').replace(/\//g, '_').replace(/\=/g, '').replace(/={1,2}$/, '');
}

function base64URL_decode(b64urlstring) 
{
  return new Uint8Array(atob(b64urlstring.replace(/-/g, '+').replace(/_/g, '/')).split('').map(val => {
    return val.charCodeAt(0);
  }));
}

