<?php

require 'IHttpClient.php';
#require 'Log.php';
class Curl implements IHttpClient{

    private $url;
    private $curlHandle;
    private $response;
    private $error;
    private $errorcode;
    private $isError;
#private $logger;

    public function __construct(){

    }

    public function init($url){
        $this->url = $url;
        $this->curlHandle = curl_init();
#$this->logger = new Log('/tmp/logger.log');
        return $this;
    }
    private  function setOptions($options){
            $defaults = array(CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 0);
            curl_setopt_array($this->curlHandle,$defaults);
            curl_setopt_array($this->curlHandle,$options);
        
    }
    public function get($queryParams, $curl_opts = NULL){
        $url = $this->url.'?'.$queryParams;

        $curlOptions = array(CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => $url,
            CURLOPT_USERAGENT => 'GRAS API');

        if($curl_opts)
        {
            foreach($curl_opts as $k => $v)
            {
                $curlOptions[$k] = $v;
            }
        }

        $this->setOptions($curlOptions);
        
        $resp = curl_exec($this->curlHandle);
 
        $this->afterResponse($resp);
        curl_close($this->curlHandle);
        return  $this->sendResponse();
    }

    private  function sendResponse(){
       
        if(is_null($this->response)){
            return array(
                'status' => 'failure',
                'error' => $this->error,
                'errorcode' => $this->errorcode,
            );
        }else{
            return array(
            'status' => 'success',
            'response' => $this->response
            );
        }
    }

    public function post($requestBody,$curl_opts = NULL){
        $url = $this->url;
        $curlOptions = array(CURLOPT_RETURNTRANSFER => true,
        CURLOPT_URL => $url,
        CURLOPT_POSTFIELDS => $requestBody,
        CURLOPT_USERAGENT => 'GRAS API');

        if($curl_opts)
        {
            foreach($curl_opts as $k => $v)
            {
                $curlOptions[$k] = $v;
            }
        }

        $this->setOptions($curlOptions);
        
        $resp = curl_exec($this->curlHandle);
        $info = curl_getinfo($this->curlHandle);
        $this->afterResponse($resp);
#$this->logger->log('DEBUG',"Closing curl.....".print_r($info,true));
        curl_close($this->curlHandle);
        return  $this->sendResponse();
    }


public function close()
{
 curl_close($this->curlHandle);
}
    public function delete($params){

    }
    public function put($params){

    }
    private  function afterResponse($response){
       
        if(!$response){
            $this->error = curl_error($this->curlHandle);
            $this->errorcode = curl_errno($this->curlHandle);
            $this->isError = true;
            $this->response = null;
    }else{
        $this->response = $response;
    }
    }
}



?>
