<?php

define('PADDED_CLIENT_SECRET_LENGTH',64);

class Helper
{
    protected $logger;

    public function __construct()
    {

    }

    function getSharedSecretHash($secret, $rpId)
	{
		$paddedSharedSecret = $this->getPaddedSharedsecret($secret);

		$xorString = $this->computeXOR($paddedSharedSecret,$rpId);

		$hashedSecret = $this->computeHash($xorString);

        return $hashedSecret;
	}
    
    private function getPaddedSharedsecret($secret)
    {
        $padding_string = "";
        
        $length_of_secret = strlen($secret);

        $padding_length = intval(PADDED_CLIENT_SECRET_LENGTH) - intval($length_of_secret);
        $length = $padding_length;

        if($padding_length > 0)
        {
            while(strlen($length >0))
            {
                $padding_string = $padding_string . substr($secret,0,$length);
                $length = intval($padding_length) - intval(strlen(($padding_string)));
            }
        }

        return $secret.$padding_string;
    }

    private function computeXOR($string1,$string2)
    {
        $str1_len = strlen($string1);
        $str2_len = strlen($string2);

        if($str1_len > $str2_len)
        {
            $padding_length = $str1_len - $str2_len;

            for($i = 0; $i < $padding_length; $i++)
            {
                $string2 .= "0";
            }
        }
        elseif($str2_len > $str1_len)
        {
            $padding_length = $str2_len - $str1_len;

            for($i = 0; $i < $padding_length; $i++)
            {
                $string1 .= "0";
            }
        }

        $xor_output = $string1 ^ $string2;

        return $xor_output;
    }

    private function computeHash($string)
    {
        $hashed_string = openssl_digest($string, 'sha256');

        return $hashed_string;
    }

    public function computeHashHmac($payload, $secret)
	{
		ksort($payload,SORT_STRING | SORT_FLAG_CASE);

		$payloadQueryString = http_build_query($payload);

		$hmac = hash_hmac('sha256', utf8_encode($payloadQueryString), $secret, true);

		return base64_encode($hmac);

	}
}

?>