<?php

class Log 
{

	private $handle;
	private $dateFormat;

	public function __construct($logFile, $operationMode = "a")
	{
		$path_parts = pathinfo($logFile);
		if(!file_exists($path_parts['dirname']))
		{
			mkdir($path_parts['dirname'],644,true);
		}
		$this->handle = fopen($logFile, $operationMode);
		$this->dateFormat = "d/M/Y H:i:s";
	}

	public function setDateFormat($format)
	{
		$this->dateFormat = $format;
	}
	
	public function log($logLevel, $entries)
	{
		if(is_string($entries))
		{
			fwrite($this->handle, "$logLevel: [" . date($this->dateFormat) . "] " . $entries . "\n");
		}
		else
		{
			foreach($entries as $value)
			{
				fwrite($this->handle, "$logLevel: [" . date($this->dateFormat) . "] " . $value . "\n");
			}
		}
	}

}

?>