<?php

require 'GrsFido2ClientService.php';

$json = file_get_contents('php://input');
$reqData = json_decode($json,true);

if(array_key_exists('fido2Auth', $reqData))
{
   $config = require('config.php');
   
   $fido2Server = $config['server'];
   $clientId = $config['client_id'];
   $sharedSecret = $config['shared-secret'];

   try
   {
   	$fido2Service = new GrsFido2ClientService($fido2Server,$clientId,$sharedSecret);
   }
   catch(Exception $e)
   {
	shell_exec("echo ".$e->getMessage()." >> /tmp/catch.txt");
	echo json_encode(['success' => false, 'msg' => $e->getMessage()]);
	exit;
   }

   $serverResponse = $fido2Service->proxyFido2Request($reqData['fido2Payload']);
   
   echo $serverResponse;

}
else
{
   echo json_encode(['status' => false]);
}

?>

