<?php

/* LICENSE:
 *
 * Copyright (c) 2009  Yubico.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * o Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * o Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * o The names of the authors may not be used to endorse or promote
 *   products derived from this software without specific prior written
 *   permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
include_once 'NotificationProvider.php';

require_once 'ykropval-common.php';
require_once 'ykropval-config.php';
require_once 'Yubico_YkMap.php';

header("content-type: text/plain");

// Setup logging
global $myLog;
global $confs;
global $auth_status; //Possible values: 0 = failed; 1 = success; 2 = sucess_yk_alone; 3 = success_ldap_alone
global $email_subject, $email_message, $email_from, $service_failed, $failed_service, $valhttps, $maphttps, $append_usr_or_passwd, $temp_pass_length;
global $ldap_host, $ldap_port, $ldap_version, $ldap_secured, $ldap_timeout, $ldap_host1, $user_full_name, $check_auto_provisioning, $key_records_found, $calling_station_id, $nas_id, $authentication_source, $auth_success_detail, $auth_failure_detail;
$auth_failure_detail = "Wrong username or password";

$check_auto_provisioning = 0;
$key_records_found = 0;
$auth_status = 1;
$myLog = new Log('ykropval-verify');
$myLog->addField('ip', $_SERVER['REMOTE_ADDR']);
$myLog->log(LOG_DEBUG, "Authentication request received for user: " . $_POST['user'] . " (" . obfuscateString($_POST['password']) . ")");
//Restrict HTTP GET requests
if ($_SERVER['REQUEST_METHOD'] == 'GET')
{
    logdie("ERROR Invalid Request");
}

// Extract values from HTTP request
$timestamp = getHttpVal('timestamp', 0);
$username_temp_pass_capital = getHttpVal_pass('user', 0);
$username = strtolower(getHttpVal_pass('user', 0));
$passwd = getHttpVal_pass('password', null);
$sflag = getHttpVal('sflag', 'true');
$radflag = getHttpVal('radflag', 0);
$nas_id = getHttpVal('nas_id', 0);

$calling_station_id = getHttpVal('calling_station_id', 0);
$authentication_source = getHttpVal('authentication_source', "Web API");

$myLog->log(LOG_DEBUG, "In ykropval-verify.php.");
$myLog->log(LOG_DEBUG, "ykropval-verify.php : checking for forcedldapauth.");
$force_ldap_auth = 0;
if ($sflag == "forceldapauth")
{
    $force_ldap_auth = 1;
    $sflag = 'true';
}

$myLog->log(LOG_DEBUG, "ykropval-verify.php : sflag set to {$sflag}.");

if ($sflag == 'true')
{
    if ($username)
    {
        $temp_pass_length = "temp_passwd_length";
        $append_usr_or_passwd = "append_otp_to_un_or_passwd";
        $passwd_with = getSysSettingValue($append_usr_or_passwd);

        #Check if multiple active domains are present and domain name is not given in username
        if (countDomains(true) > 1)
        {
            $error_flag = 0;

            if (strstr($username, ":") != FALSE)
            {
                $error_flag = 1;
            }
            else if (strstr($username, "\\\\") != FALSE)
            {
                $error_flag = 1;
            }
            else if (strstr($username, "@") != FALSE)
            {
                $error_flag = 1;
            }

            if (!$error_flag && $passwd_with != "username")
            {
                //Check if user exists in only one domain
                $userdomain = getUserDomain($username);

                if (!$userdomain)
                {
                    //check if default domain is defined or not
                    $myLog->log(LOG_DEBUG, "User- $username exists in multiple domains, hence finding default domain");
                    $domain = getDefaultDomain();
                    if (!$domain)
                    {
                        log_authentication($username, '', '', 0, 'Could not determine domain', 0, '', 'AUTH-09--0-2');
                        $myLog->log(LOG_ERR, 'Authentication failed: missing domain in Username- ' . $username);
                        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                        exit;
                    }
                }
            }
        }

        $myLog->log(LOG_DEBUG, "ykropval-verify.php : separating user password.");
        $parsedParams = seperateUserPasswd($username, $passwd, $passwd_with);

        $user_domain = seperatUsersAndDomain($parsedParams['user']);
        if (!$user_domain)
        {
            log_authentication($username, $yubikeyid, '', 0, 'Could not determine domain', 0, '', 'AUTH-09--0-2');
            $myLog->log(LOG_ERR, 'Authentication failed: domain not found for user- ' . $username);
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            exit;
        }
        $user = $user_domain[0];
        $parsedParams['group_info_user'] = $user;
        $domain = $user_domain[1];
        $fullusername = $user . "@" . $domain;
        $confs = getRopConfiguration($user, $domain);

        $user_password = $parsedParams['password'];


        $myLog->log(LOG_DEBUG, "Fetching all user tokens for {$fullusername}.");
        $user_tokens = get_all_token_types($fullusername); /* Should return all tokens associated with user */
        $myLog->log(LOG_DEBUG, "User {$fullusername} has following tokens: " . implode(",", $user_tokens));

        $myLog->log(LOG_DEBUG, "*************** YKROPVAL-VERIFY ***************");

        if (!$confs)
        {
            //Log authentication
            log_authentication($fullusername, $yubikeyid, '', 0, 'Internal server error (101)', 0, '', 'AUTH-09--0-2');
            $myLog->log(LOG_ERR, 'Authentication failed: failed to read configuration for user- ' . $username);
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            exit;
        }

        if (ldapVerification($user, $parsedParams['password'], $domain, $fullusername, null))
        {
            if ($parsedParams['tokenType'] == "yubikey")
            {
                grsYubikeyOtpValidation($parsedParams, $domain, $fullusername, $user);
            }
            else if ($parsedParams['tokenType'] == "oath")
            {
                grsYubikeyOathOtpValidaton($parsedParams, $domain, $fullusername, $user);
            }
            else if ($parsedParams['tokenType'] == "temp")
            {
                grsTempPassValidation($parsedParams, $domain, $fullusername, $user);
            }
            else
            {
                if (gradual_deployment($user, $domain))
                {
                    $group_info = fetchGroupInfo($parsedParams['group_info_user'], $domain);
                    log_authentication($fullusername, '', '', 3, $auth_success_detail, 0, $group_info, "AUTH-05-01-1-0");
                    sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $parsedParams['user']));
                    $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername);
                    exit;
                }
                if (checkModuleInstalled(S_MODULE_ID_M2F_SIMPLE) && has_m2f_assigned($fullusername) && is_m2f_enabled_for_user($fullusername))
                {
                    $uan = new NotificationProvider('UrbanAirship');
                    $myLog->log(LOG_DEBUG, "Fetching Android IDs for {$fullusername}.");

                    /* Fetch user's Android channel IDs and set them for notification */
                    $and_ids = get_android_channel_ids($fullusername, true);
                    $myLog->log(LOG_DEBUG, "Android IDs for {$fullusername} are : " . implode(",", $and_ids));
                    if ($and_ids)
                    {
                        $uan->setAndroidChannelId($and_ids);
                    }

                    /* Fetch user's iOS channel IDs and set them for notification */
                    $myLog->log(LOG_DEBUG, "Fetching iOS IDs for {$fullusername}.");
                    $ios_ids = get_ios_channel_ids($fullusername, true);
                    if ($ios_ids)
                    {
                        $uan->setIosChannelId($ios_ids);
                    }

                    /* Notification pushing will be done by the function - before it goes into wait for
                     * checking queue status.
                     */
                    $rc = grsM2fSimpleValidation($domain, $fullusername, $user, $user_password, $uan, $parsedParams['group_info_user']);
                }
                elseif (checkModuleInstalled(S_MODULE_ID_U2F))
                {
                    if (has_token_assigned($fullusername, "u2f") && is_token_enabled_for_user($fullusername, "u2f"))
                    {
                        grsYubikeyU2FValidaton($domain, $fullusername, $user, $parsedParams['group_info_user']);
                    }
                    else
                    {
                        grsU2FRegistration($domain, $fullusername, $user, $parsedParams['group_info_user']);
                    }
                }
                else
                {
                    log_authentication($fullusername, '', '', 0, 'Wrong username or password', 0, '', 'AUTH-09--0-2');
                    sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                    exit;
                }
            }
        }
        else if ($parsedParams['tokenType'] == "single_or_invalid")
        {
            $user = $parsedParams['user'];
            if (gradual_deployment($user, $domain))
            {
                log_authentication($fullusername, '', '', 0, $auth_failure_detail, 0, '', 'AUTH-09--0-2');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                exit;
            }
            else
            {
                log_authentication($fullusername, '', '', 0, $auth_failure_detail, 0, '', 'AUTH-09--0-2');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                exit;
            }
        }
        else if ($parsedParams['tokenType'] == "temp" || $parsedParams['tokenType'] == "oath")
        {
            if ($parsedParams['tokenType'] == "oath")
            {
                if (isset($parsedParams['oathTokenIdentifier']))
                {
                    $otp_part = $parsedParams['oathTokenIdentifier'] . $parsedParams['oathHotp'];
                }
                else
                {
                    $otp_part = $parsedParams['oathHotp'];
                }
            }
            else
            {
                $otp_part = $parsedParams['otp'];
            }
            if ($passwd_with == "username")
            {
                $user_temp = $parsedParams['user'] . $otp_part;
                $passwd_temp = $parsedParams['password'];
            }
            else if ($passwd_with == "password" || $passwd_with == "always_ask")
            {
                $passwd_temp = $parsedParams['password'] . $otp_part;
                $user_temp = $parsedParams['user'];
            }
            if (ldapVerification($user_temp, $passwd_temp, $domain, $fullusername, null, $force_ldap_auth))
            {
                if (gradual_deployment($user, $domain))
                {

                    $group_info = fetchGroupInfo($parsedParams['group_info_user'], $domain);
                    log_authentication($fullusername, '', '', 3, $auth_success_detail, 0, $group_info, "AUTH-05-01-1-0");
                    sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $parsedParams['user']));
                    $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $user . ' using single factor');
                    exit;
                }
                if (checkModuleInstalled(S_MODULE_ID_U2F))
                {
                    grsYubikeyU2FValidaton($domain, $fullusername, $user, $parsedParams['group_info_user']);
                }
                else
                {
                    log_authentication($fullusername, '', '', 0, 'Wrong username or password', 0, '', 'AUTH-09--0-2');
                    sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                    $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $user . ' using U2F token');
                    exit;
                }
            }
            else
            {
                log_authentication($fullusername, '', '', 0, $auth_failure_detail, 0, '', 'AUTH-09--0-2');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $user);
                exit;
            }
        }
        else
        {
            log_authentication($fullusername, '', '', 0, 'Wrong username or password', 0, '', 'AUTH-09--0-2');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $user . ' wrong username or password');
            exit;
        }
    }
}
$myLog->log(LOG_DEBUG, 'Entering LDAP Bind Test.');
//Directory authentication test
if ($sflag == "ldapBindTest")
{
    $myLog->log(LOG_DEBUG, 'Entered LDAP Bind Test.');
    if ($user_domain = seperatUsersAndDomain($username))
    {
        $user = $user_domain[0];
        $domain = $user_domain[1];
        $fullusername = $user . "@" . $domain;
        $confs = getRopConfiguration($user, $domain);

        $myLog->log(LOG_DEBUG, 'User domain separated from full username.');

        if (!$confs)
        {
            //Log authentication
            log_authentication($fullusername, $yubikeyid, '', 0, 'Internal server error (102)', 0, '', 'AUTH-09--0-2');
            $myLog->log(LOG_ERR, 'Failed to read the RoP configuration');
            echo "*Failed!";
            exit;
        }
    }
    else
    {
        $myLog->log(LOG_DEBUG, 'Couldn\'t determine domain.');
        log_authentication($username, $yubikeyid, '', 0, 'Could not determine domain', 0, '', 'AUTH-09--0-2');
        echo "*Failed!";
        exit;
    }
    $dirLdapTestFlag = true;
    $myLog->log(LOG_DEBUG, 'Doing LDAP verification.');
    if (ldapVerification($user, $passwd, $domain, $fullusername, null, $dirLdapTestFlag))
        echo "*Successful!";
    else
        echo "*Failed!";
}
$myLog->log(LOG_DEBUG, 'Exiting LDAP Bind Test.');

//YubiKey/Google Auth - OATH-HOTP validation
function grsYubikeyOathOtpValidaton($inputParams, $domain, $fullusername, $username)
{
    global $confs;
    global $myLog;
    global $auth_success_detail;
    $myLog->log(LOG_DEBUG, 'Verifying user using OATH validation');

    $count_db = getUserMappingsCount("oath");
    $token_type_license = S_MODULE_ID_GRSOATH;
    $response_license = verifyLicense($token_type_license, $count_db);
    if ($response_license == 0)
    {
        log_authentication($fullusername, $userTokenMapping, 'OATH', 0, 'reached limit of user-token associations permitted', 0, '', 'AUTH-02-01-0-18');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' reached limit of user-token associations permitted for OATH');
        exit;
    }
    if ($response_license == -1)
    {
        log_authentication($fullusername, $userTokenMapping, 'OATH', 0, 'Invalid or expired license', 0, '', 'AUTH-02-01-0-19');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Invalid or expired license');
        exit;
    }

    $userTokenMapping = urldecode(getUserMappings($fullusername, "oath"));
    $identifier_append = $inputParams["identifier_append"];


    if ($identifier_append == "true")
    {
        //checking if auto_provisioning is enabled
        $token_id_found = getOathTokenIdParam($inputParams['oathTokenIdentifier'], "public_token_id", 1, $fullusername);
        if (preg_match("/(" . $token_id_found . ")/", $userTokenMapping, $fields) == 0)
        {

            $myLog->log(LOG_DEBUG, ' Found mapping for user:' . $fullusername . ' OATH token id- ' . $token_id_found);

            if (!$userTokenMapping && ($confs['auto_provisioning_oath']))
            {
                $auto_provisioning_oath_flag = 1;
            }
            else
            {
                if ($userTokenMapping)
                {
                    $check_oath_mappings_of_user = checkOathMappingsUser($userTokenMapping, $token_id_found);
                }
                //checking if token is used for first time
                if ($confs['auto_provisioning_oath'] && $check_oath_mappings_of_user == 1 && $token_id_found)
                {
                    $auto_provisioning_oath_flag = 1;
                }
                else if ($confs['multi_tokens_auto_provisioning_oath'] && $check_oath_mappings_of_user > 1 && $token_id_found)
                {
                    $auto_provisioning_oath_flag = 1;
                }
                else
                {
                    $userTokenMapping = 0;
                    $auto_provisioning_disabled = 1;
                }
            }

            $ykmapAuth = &new Auth_Yubico_YkMap();
            $res = $ykmapAuth->search('yubikey_prefix', $token_id_found, 'username', '', 'oath');
            $key_to_multiple_user_flag = getSysSettingValue('assign_key_to_multiple_oath_user');

            if (($res === 1 || !preg_match("/NO_RECORDS_FOUND/", $res)) && ((isset($key_to_multiple_user_flag) && $key_to_multiple_user_flag != "") && $key_to_multiple_user_flag != 1))
            {

                log_authentication($fullusername, $token_id_found, 'OATH', 0, "OATH token- $token_id_found is already assigned to another user", 0, '', 'AUTH-02-01-0-20');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . " OATH token- $token_id_found is already assigned to another user");
                exit;
            }
        }
        else if (!$token_id_found)
        { //if public token id not found using oath token identifier
            $userTokenMapping = 0;
            $token_id_not_found = 1;
            $auto_provisioning_disabled = 1;
        }
    } #

    if ($userTokenMapping || $auto_provisioning_oath_flag)
    {
        if ($auto_provisioning_oath_flag)
        {
            $max_tokens_per_user_allowed = getSysSettingValue("max_tokens_per_user");
            $records_count = find_no_of_mapping_records_a_user($ykmap_url, $fullusername, "all");
            if ($records_count >= $max_tokens_per_user_allowed)
            {
                $myLog->log(LOG_DEBUG, 'User: ' . $fullusername . ' Token id: ' . $token_id_found . ' Auto provisioning of OATH token failed: Maximum number number of tokens per user limit reached');
                log_authentication($fullusername, $token_id_found, 'OATH', 0, 'Auto-provisioning failed: user already has maximum number of tokens assigned', 0, '', 'AUTH-02-02-0-24');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Auto-provisioning failed: user already has maximum number of tokens assigned');
                exit;
            }
            $hotpVeification_status = verificationHotp($inputParams['oathHotp'], $token_id_found . "&");
        }
        else
        {
            if ($token_id_found)
            {
                $hotpVeification_status = verificationHotp($inputParams['oathHotp'], $token_id_found . "&");
            }
            else
            {
                $hotpVeification_status = verificationHotp($inputParams['oathHotp'], $userTokenMapping);
            }
        }

        if ($hotpVeification_status[0] === true)
        {
            if ($auto_provisioning_oath_flag)
            {
                //auto provisioning OATH token
                $myLog->log(LOG_DEBUG, 'Auto-provisioning OATH token to user: ' . $fullusername);
                if (!add_mapping_records($ykmap_service_url, $fullusername, $token_id_found, "oath"))
                {
                    $myLog->log(LOG_ERR, 'Auto-provisioning failed: unable to assign an OATH token to user: ' . $fullusername);
                    log_authentication($fullusername, $token_id_found, 'OATH', 0, "Unable to assign a token to user due to internal error", 0, '', 'AUTH-02-02-0-23');
                    $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Auto-provisioning failed: unable to assign an OATH token to user');
                    sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                    exit;
                }
            }

            update_user_temp_pass_status($username, $domain);
            update_gradual_deployment_flag($username, $domain);
            $group_info = fetchGroupInfo($inputParams['group_info_user'], $domain);

            if (sizeof($hotpVeification_status[2]) == 2)
            {
                log_authentication($fullusername, $hotpVeification_status[2][0], 'OATH', 1, $auth_success_detail, 0, $group_info, 'AUTH-02-01-1-0');
                $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ' using OATH token- ' . $hotpVeification_status[2][0]);
            }
            else
            {
                log_authentication($fullusername, $hotpVeification_status[1], 'OATH', 1, $auth_success_detail, 0, $group_info, 'AUTH-02-01-1-0');
                $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ' using OATH token- ' . $hotpVeification_status[1]);
            }
            sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $inputParams['user']));
            exit;
        }
        else
        {
            $hotpVeification_status_msg = ucwords(str_replace("_", " ", $hotpVeification_status[1]));
            if (sizeof($hotpVeification_status[2]) == 2)
            {
                log_authentication($fullusername, $hotpVeification_status[2][0], 'OATH', 0, $hotpVeification_status_msg, 0, '', 'AUTH-02-01-0-21');
                $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ' using OATH token- ' . $hotpVeification_status[2][0] . ' ' . $hotpVeification_status_msg);
            }
            else
            {
                log_authentication($fullusername, "", 'OATH', 0, $hotpVeification_status_msg, 0, '', 'AUTH-02-01-0-21');
                $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ' ' . $hotpVeification_status_msg);
            }
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            exit;
        }
    }
    else
    {
        if ($auto_provisioning_disabled)
        {
            if ($token_id_not_found)
            {
                $myLog->log(LOG_DEBUG, 'OATH token identifier not found');
            }
            else
            {
                $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Auto-provisioning for OATH token is disabled');
                log_authentication($fullusername, $token_id_found, 'OATH', 0, 'Token is not assigned to user', 0, '', 'AUTH-02-02-0-22');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                exit;
            }
        }
        log_authentication($fullusername, (($userTokenMapping == 0) ? "" : $userTokenMapping), 'OATH', 0, 'Token is not assigned to user', 0, '', 'AUTH-02-02-0-25');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        exit;
    }
}

//Temporary token validation
function grsTempPassValidation($inputParams, $domain, $fullusername, $username)
{
    global $confs;
    global $myLog;
    global $auth_success_detail;
    $otp = $inputParams['otp'];
    $passwd = $inputParams['password'];

    if (temp_validate_password($otp, $domain, $username))
    {
        if (($confs['domainconf']['temp_passwd_enable'] == 1) && ($confs['domainconf']['max_auth_allowed'] > 0) && ($confs['domainconf']['temp_passwd_expiry'] >= date("Y-m-d")))
        {
            if (update_user_count($username, $domain))
            {

                $group_info = fetchGroupInfo($inputParams['group_info_user'], $domain);
                log_authentication($fullusername, $yubikeyid, '', 4, $auth_success_detail, 0, $group_info, 'AUTH-06-01-1-0');
                sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $inputParams['user']));
                $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ' using Temporary token- ' . $otp);
                exit;
            }
        }
        else
        {
            if ($confs['domainconf']['max_auth_allowed'] > 0)
            {
                log_authentication($fullusername, $yubikeyid, '', 0, 'Temporary token- reached limit of number of authentications permitted', 0, '', 'AUTH-06-01-0-7');
            }
            else if ($confs['domainconf']['temp_passwd_expiry'] >= date("Y-m-d"))
            {
                log_authentication($fullusername, $yubikeyid, '', 0, 'Temporary token is expired', 0, '', 'AUTH-06-01-0-7');
            }
            else
            {
                log_authentication($fullusername, $yubikeyid, '', 0, 'Temporary token validation failed', 0, '', 'AUTH-06-01-0-7');
            }
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ' using Temporary token');
            exit;
        }
    }
}

//YubiKey-OTP validation
function grsYubikeyOtpValidation($inputParams, $domain, $fullusername, $username)
{

    global $confs;
    global $auth_success_detail;
    global $myLog;
    global $key_records_found;
    global $check_auto_provisioning;
    $myLog->log(LOG_DEBUG, 'Verifying user using YubiKey OTP validation');

    $count_db = getUserMappingsCount("yubikey");
    $token_type_license = S_MODULE_ID_YUBIKEY;
    $response_license = verifyLicense($token_type_license, $count_db);
    if ($response_license == 0)
    {
        log_authentication($fullusername, $userTokenMapping, 'YubiKey', 0, 'reached limit of user-token associations permitted', 0, '', 'AUTH-01-01-0-10');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ', reached limit of user-token associations permitted');
        exit;
    }
    if ($response_license == -1)
    {
        log_authentication($fullusername, $userTokenMapping, 'YubiKey', 0, 'Invalid or expired license', 0, '', 'AUTH-01-01-0-11');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ', Invalid or expired license');

        exit;
    }

    $user = $inputParams['user'];
    $yubikeyid = $inputParams['yubikeyId'];
    $otp = $inputParams['otp'];
    $verifyYkmap = verificationOfYkmaping($user, $yubikeyid, $fullusername, "yubikey");
    if ($verifyYkmap && ($confs['domainconf']['temp_passwd_enable'] == 1))
    {
        if (verificationOtp($user, $domain, $fullusername, $yubikeyid, $otp, $myLog, $confs, $email_subject, $email_message, $email_from, $service_failed, $failed_service, $valhttps, $maphttps))
        {
            update_user_temp_pass_status($username, $domain);

            $group_info = fetchGroupInfo($inputParams['group_info_user'], $domain);
            log_authentication($fullusername, $yubikeyid, 'YubiKey', 1, $auth_success_detail, 0, $group_info, 'AUTH-01-01-1-0');
            update_gradual_deployment_flag($user, $domain);
            sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $inputParams['user']));
            $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $user . ' for YubiKey token id- ' . $yubikeyid);
            exit;
        }
        else
        {
            log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'OTP validation falied', 0, '', 'AUTH-01-01-0-12');
            sendResp(S_INVALID_OTP, $apiKey, $extra);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' for YubiKey token id- ' . $yubikeyid . ', OTP validation falied');
            exit;
        }
    }
    else if ($verifyYkmap)
    {
        if (verificationOtp($user, $domain, $fullusername, $yubikeyid, $otp, $myLog, $confs, $email_subject, $email_message, $email_from, $service_failed, $failed_service, $valhttps, $maphttps))
        {

            $group_info = fetchGroupInfo($inputParams['group_info_user'], $domain);
            log_authentication($fullusername, $yubikeyid, 'YubiKey', 1, $auth_success_detail, 0, $group_info, 'AUTH-01-01-1-0');
            update_gradual_deployment_flag($username, $domain);

            sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $inputParams['user']));
            $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $user . ' for YubiKey token id- ' . $yubikeyid);
            exit;
        }
        else
        {
            log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'OTP validation falied', 0, '', 'AUTH-01-01-0-12');
            sendResp(S_INVALID_OTP, $apiKey, $extra);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user' . $fullusername . ' for YubiKey token id- ' . $yubikeyid . ', OTP validation falied');
            exit;
        }
    }
    else
    {
        if (($check_auto_provisioning == 1) && ($key_records_found == 0))
        {
            if (verificationOtp($user, $domain, $fullusername, $yubikeyid, $otp, $myLog, $confs, $email_subject, $email_message, $email_from, $service_failed, $failed_service, $valhttps, $maphttps))
            {
                if (!AutoProvision($user, $domain, $yubikeyid, $fullusername, $inputParams['group_info_user']))
                {
                    log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'Token is not assigned to user (and auto-provisioning is also disabled)', 0, '', 'AUTH-01-02-0-14');
                    $myLog->log(LOG_ERR, 'Token is not assigned to user (and auto-provisioning is also disabled)');
                    sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                    exit;
                }
            }
            else
            {
                log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'Incorrect OTP', 0, '', 'AUTH-01-02-0-15');
                sendResp(S_INVALID_OTP, $apiKey, $extra);
                $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' for YubiKey token id- ' . $yubikeyid . ', Auto-provisioning failed: OTP validation falied');
                exit;
            }
        }
        else
        {
            log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'Token is not assigned to user', 0, '', 'AUTH-01-01-0-13');
            $myLog->log(LOG_ERR, 'Username-YubiKey mapping not found');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' for YubiKey token id- ' . $yubikeyid . ', Token is not assigned to user');
            exit;
        }
    }
}

function grsM2fSimpleValidation($domain, $fullusername, $username, $password, NotificationProvider $np, $group_info_user = null)
{
    global $confs;
    global $myLog;
    global $auth_success_detail;

    $myLog->log(LOG_DEBUG, 'Verifying if the user is using M2F validation');

    $authentication = is_authentic_user($fullusername, $password);

    if ($authentication == false)
    {
        $np->setNotificationMessage("A failed login was attempted by {$fullusername} on {$domain}.");
        $np->push();
        insertIntoAuditlog_M2F("User Authentication failed for user: " . strtolower($fullusername), "ERROR");
        return BASIC_USER_AUTHENTICATION_FAILED;
    }

    $count_db = getUserMappingsCount("m2f");
    $token_type_license = S_MODULE_ID_M2F_SIMPLE;
    $response_license = verifyLicense($token_type_license, $count_db);

    switch ($response_license)
    {
        case 0:
            insertIntoAuditlog_M2F("failed to authenticate M2F token of user: " . strtolower($fullusername) . ", number of users exceeded", "ERROR");
            log_authentication(strtolower($username), "", "M2F", 0, "User limit exceeded");
            echo "Error: Number of users exceeded for token type- M2F";
            exit;

        case -1:
            insertIntoAuditlog_M2F("failed to authenticate M2F token of user: " . strtolower($fullusername) . ", expired license for token type- M2F", "ERROR");
            log_authentication(strtolower($username), "", "M2F", 0, "License expired");
            echo "Error: Expired license for token type- M2F";
            exit;
        case 1:
            break;
    }

    $is_m2f_enabled_for_user = is_m2f_enabled_for_user($fullusername); # enabled for user

    if ($is_m2f_enabled_for_user)
    {

        $results = explode("&", urldecode(getUserMappings($fullusername, "m2f")));
        $result = $results[0];
        $myLog->log(LOG_DEBUG, "Token_Assignment param: {$result}");

        $timeout = getSysSettingValue("m2f_auth_timeout");

        if (!$timeout)
        {
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to find value for timeout from RoP configuration');
            $np->setNotificationMessage("Your authentication couldn't be processed as no timeout was defined in the system. Please contact your adminsitrator.");
            $myLog->log(LOG_DEBUG, "Sending SYS_CONF_NO_TIMEOUT_DEFINED notification to {$fullusername}.");
            $rc = $np->push();
            $myLog->log(LOG_DEBUG, "Pushed notification for {$fullusername}.");
            $myLog->log(LOG_DEBUG, "Push resp: {$rc}.");
            return SYS_CONF_NO_TIMEOUT_DEFINED;
        }

        $reference = generate_reference(5);

        $queueAddRes = addUserM2fQueue($fullusername, $result, $timeout, $reference);

        if (!$queueAddRes)
        {
            $myLog->log(LOG_ERR, 'Failed to add user in a queue');
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to add user in a queue');
            $np->setNotificationMessage("Your authentication couldn't be processed as it couldn't be queued. Please contact your administrator.");
            $myLog->log(LOG_DEBUG, "Sending QUEUE_ADD_FAILED notification to {$fullusername}.");
            $np->push();
            $myLog->log(LOG_DEBUG, "Pushed notification for {$fullusername}.");
            $myLog->log(LOG_DEBUG, "Push resp: {$rc}.");
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            return QUEUE_ADD_FAILED;
        }


        if (!checkUserM2fQueueStatus($fullusername, $reference))
        {
            //sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to find user status in a queue');
            $np->setNotificationMessage("Your authentication couldn't be processed as it couldn't be found in queue. Please contact your administrator.");
            $myLog->log(LOG_DEBUG, "Sending QUEUE_NO_ENTRY notification to {$fullusername}.");
            $np->push();
            $myLog->log(LOG_DEBUG, "Push resp: {$rc}.");
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            return QUEUE_NO_ENTRY;
        }


        /* No errors, if we made it this far. Send a notification to user seeking approval for the authentication request */
        $myLog->log(LOG_DEBUG, "Sending 2FA request notification to {$fullusername}.");
        $now = date("Y-m-d H:i:s");
        $np->setNotificationMessage("{$fullusername} is trying to log in. Tap to approve or reject.");
        $np->set_extra("Reference", $reference);
        $np->set_extra("Username", $fullusername);
        $np->set_extra("DomainName", $domain);
        $np->set_extra("LoginTime", $now);
        $np->set_extra("TimeOut", $timeout);
        $np->set_extra("TimeZone", date_default_timezone_get());
        $myLog->log(LOG_DEBUG, "Push data: " . $np->get_payload());
        $rc = $np->push();

        $push_response = json_decode($rc);

        if ($push_response->ok == false)
        {
            insertIntoAuditlog_M2F("Couldn't push notification: {$rc}.", "ERROR");
        }

        if ($rc == false)
        {
            $myLog->log(LOG_DEBUG, "Failed to push notification for {$fullusername}.");
            $myLog->log(LOG_ERR, $np->get_errors_string());
            return PUSH_NOTIFICATION_SENDING_FAILED;
        }
        else
        {
            $myLog->log(LOG_DEBUG, $rc);
            $myLog->log(LOG_DEBUG, "Pushed notification for {$fullusername}.");
            $myLog->log(LOG_DEBUG, "Push resp: {$rc}.");
        }

        $i = 0;
        while (checkUserM2fQueueStatus($fullusername, $reference) == "pending" && $i < $timeout)
        {
            $i++;
            sleep(1);
        }

        /* Get status of queue item just after timeout period or after status
         * changed from pending to something else */
        $statusCheck = checkUserM2fQueueStatus($fullusername, $reference);

        /* Delete the item from queue */
        $delStatusCheck = delUserM2fQueue($fullusername, $reference);


        /* If the status of queue item was successful */
        if (strcasecmp($statusCheck, "successful") == 0)
        {
            $group_info = fetchGroupInfo($group_info_user, $domain);
            sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $fullusername));
            $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ' using M2F token');
            insertIntoAuditlog_M2F("User {$username} authenticated successfully", "LOG");
            log_authentication(strtolower($fullusername), "", "M2F", 1, "Authentication successful");
            return TFA_USER_AUTHENTICATION_PASSED;
        }
        else
        {
            if (strcasecmp($statusCheck, "declined") == 0)
            {
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                insertIntoAuditlog_M2F("Failed to authenticate user {$username} as authentication was declined.", "LOG");
                $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', Authentication declined by user');
                log_authentication(strtolower($fullusername), "", "M2F", 0, "Authentication declined by user");
                return TFA_USER_AUTHENTICATION_FAILED;
            }
            if (strcasecmp($statusCheck, "pending") == 0)
            {
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', M2F authentication failed: operation timed out');
                insertIntoAuditlog_M2F("Failed to authenticate user {$username} as authentication timed-out", "ERROR");
                log_authentication(strtolower($fullusername), "", "M2F", 0, "Operation Timed Out");
                return USER_AUTHENTICATION_TIMED_OUT;
            }
        }
    }
    else
    {
        $myLog->log(LOG_DEBUG, "M2F token disabled for user : {$fullusername}");
        log_authentication(strtolower($fullusername), "", "M2F", 0, "Token Disabled");
        exit;
    }
}

function grsYubikeyU2FValidaton($domain, $fullusername, $username, $group_info_user = null)
{
    global $confs;
    global $myLog;
    global $auth_success_detail;
    $myLog->log(LOG_DEBUG, 'Verifying user using YubiKey U2F validation');
    $ykmap_service_url = $confs["globalconf"]['ykmap_server_url'];
    $ykmap_service_url = preg_replace("/^http[s]{0,1}:\/\//i", "", $ykmap_service_url);

    $count_db = getUserMappingsCount("u2f");
    $token_type_license = S_MODULE_ID_U2F;
    $response_license = verifyLicense($token_type_license, $count_db);

    if ($response_license == 0)
    {
        log_authentication($fullusername, $userTokenMapping, 'U2F', 0, 'reached limit of user-token associations permitted', 0, '', 'AUTH-03-01-0-26');
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' using U2F token, reached limit of user-token associations permitted');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        exit;
    }
    if ($response_license == -1)
    {
        log_authentication($fullusername, $userTokenMapping, 'U2F', 0, 'Invalid or expired license', 0, '', 'AUTH-03-01-0-27');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' using U2F token, Invalid or expired license');
        exit;
    }

    $results = explode("&", urldecode(getUserMappings($fullusername, "u2f")));
    $result = $results[0];
    if ($result)
    {
        $timeout = getSysSettingValue("u2f_auth_timeout");
        if (!$timeout)
        {
            log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Internal server error (103)', 0, '', 'AUTH-03-01-0-28');
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to find value for timeout from RoP configuration');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            exit;
        }
        $queueAddRes = addUserQueue($fullusername, $result, $timeout);
        //exit;
        if (!$queueAddRes)
        {
            log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Internal server error (104)', 0, '', 'AUTH-03-01-0-29');
            $myLog->log(LOG_ERR, 'Failed to add user in a queue');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to add user in a queue');
            exit;
        }
        if (!checkUserQueueStatus($fullusername, $queueAddRes))
        {
            log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Internal server error (105)', 0, '', 'AUTH-03-01-0-30');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to find user status in a queue');
            exit;
        }
        $i = 0;
        while (checkUserQueueStatus($fullusername, $queueAddRes) == "pending" && $i < $timeout)
        {
            $i++;
            sleep(1);
        }
        $statusCheck = checkUserQueueStatus($fullusername, $queueAddRes);
        $delStatusCheck = delUserQueue($fullusername, $queueAddRes);
        if (strcmp($statusCheck, "successful") == 0)
        {
            update_user_temp_pass_status($username, $domain);
            update_gradual_deployment_flag($username, $domain);
            $group_info = fetchGroupInfo($group_info_user, $domain);
            log_authentication($fullusername, $yubikeyid, 'U2F', 1, $auth_success_detail, 0, $group_info, 'AUTH-03-01-1-0');

            sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $fullusername));
            $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ' using U2F token');
            exit;
        }
        else
        {
            if (strcmp($statusCheck, "failed") == 0)
            {
                log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'U2F authentication failed', 0, '', 'AUTH-03-01-0-32');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', U2F authentication failed');
                exit;
            }
            if (strcmp($statusCheck, "pending") == 0)
            {
                log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Operation timed out', 0, '', 'AUTH-03-01-0-31');
                sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', U2F authentication failed: operation timed out');
                exit;
            }
        }
    }
    else
    {
        log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Token is not assigned to user', 0, '', 'AUTH-03-01-0-33');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ', Token is not assigned to user');
        exit;
    }
}

function grsU2FRegistration($domain, $fullusername, $username, $group_info_user = null)
{
    global $confs;
    global $myLog;
    global $auth_success_detail;
    $myLog->log(LOG_DEBUG, 'Verifying user using YubiKey U2F validation');
    $ykmap_service_url = $confs["globalconf"]['ykmap_server_url'];
    $ykmap_service_url = preg_replace("/^http[s]{0,1}:\/\//i", "", $ykmap_service_url);

    $count_db = getUserMappingsCount("u2f");
    $token_type_license = S_MODULE_ID_U2F;
    $response_license = verifyLicense($token_type_license, $count_db);

    if ($response_license == 0)
    {
        log_authentication($fullusername, $userTokenMapping, 'U2F', 0, 'reached limit of user-token associations permitted', 0, '', 'AUTH-03-01-0-26');
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' using U2F token, reached limit of user-token associations permitted');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        exit;
    }
    if ($response_license == -1)
    {
        log_authentication($fullusername, $userTokenMapping, 'U2F', 0, 'Invalid or expired license', 0, '', 'AUTH-03-01-0-27');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' using U2F token, Invalid or expired license');
        exit;
    }

    $timeout = getSysSettingValue("u2f_auth_timeout");
    if (!$timeout)
    {
        log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Internal server error (103)', 0, '', 'AUTH-03-01-0-28');
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to find value for timeout from RoP configuration');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        exit;
    }
    $result = "U2F_registration_request";
    $queueAddRes = addUserRegistrationQueue($fullusername, $result, $timeout);
    
    if (!$queueAddRes)
    {
        log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Internal server error (104)', 0, '', 'AUTH-03-01-0-29');
        $myLog->log(LOG_ERR, 'Failed to add user in a queue');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to add user in a queue');
        exit;
    }
    if (!checkUserQueueStatus($fullusername, $queueAddRes))
    {
        log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Internal server error (105)', 0, '', 'AUTH-03-01-0-30');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_DEBUG, 'Authentication failed for user- ' . $fullusername . ' Failed to find user status in a queue');
        exit;
    }
    $i = 0;
    while (checkUserQueueStatus($fullusername, $queueAddRes) == "registration_request" && $i < $timeout)
    {
        $i++;
        sleep(1);
    }
    $statusCheck = checkUserQueueStatus($fullusername, $queueAddRes);
//    $delStatusCheck = delUserQueue($fullusername, $queueAddRes);
    if (strcmp($statusCheck, "successful") == 0)
    {
        update_user_temp_pass_status($username, $domain);
        update_gradual_deployment_flag($username, $domain);
        $group_info = fetchGroupInfo($group_info_user, $domain);
        log_authentication($fullusername, $yubikeyid, 'U2F', 1, $auth_success_detail, 0, $group_info, 'AUTH-03-01-1-0');

        sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $fullusername));
        $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ' using U2F token');
        exit;
    }
    else
    {
        if (strcmp($statusCheck, "failed") == 0)
        {
            log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'U2F authentication failed', 0, '', 'AUTH-03-01-0-32');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', U2F authentication failed');
            exit;
        }
        if (strcmp($statusCheck, "registration_request") == 0)
        {
            log_authentication($fullusername, $yubikeyid, 'U2F', 0, 'Operation timed out', 0, '', 'AUTH-03-01-0-31');
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', U2F authentication failed: operation timed out');
            exit;
        }
    }
}

// STEP#2: Verify the password
function ldapVerification($user, $passwd, $domain, $fullusername = null, $yubikeyid = null, $dirLdapBindTestFlag = false)
{
    global $myLog;
    global $confs, $ldap_host, $ldap_port, $ldap_version, $ldap_secured, $ldap_timeout, $ldap_host1, $user_full_name, $auth_success_detail, $auth_failure_detail;
    if ($confs["globalconf"]['freeradius_check'] == true && !$dirLdapBindTestFlag)
    {
        $myLog->log(LOG_DEBUG, 'Skipping LDAP/AD verification..');
        return true;
    }
    else if (empty($passwd))
    {
        $myLog->log(LOG_DEBUG, 'Empty password recieved hence aborting LDAP/AD authentication');
        return false;
    }

    if ($confs["ldapconf"]["users_store_type"] == "Office 365")
    {
        //perform ldap verification of Office 365
        if (validate_uname_pass_with_o365($user, $passwd, $confs["ldapconf"]["tenant_name"]))
        {
            $myLog->log(LOG_DEBUG, 'username and password validation of user: ' . $user . '@' . $domain . ' is successful using Office 365 tenant');
            return true;
        }
        else
        {
            $myLog->log(LOG_DEBUG, 'username and password validation of user: ' . $user . '@' . $domain . ' is failed using Office 365 tenant');
            return false;
        }
    }

    // Connect to LDAP server
    $ldap_host = $confs["ldapconf"]["host"];
    $ldap_port = $confs["ldapconf"]["port"];
    $ldap_version = $confs["ldapconf"]["ldap_version"];
    $ldap_secured = $confs["ldapconf"]["secured"];
    $ldap_timeout = $confs["ldapconf"]["timeout"];
    $ldap_host1 = $confs["ldapconf"]["host1"];
    $allow_auth_if_pwd_exp = $confs["ldapconf"]["allow_auth_after_password_expires"];
    $directory_name = $confs["ldapconf"]["ad_ldap"];
    $user_full_name = $confs["domainconf"]["user_name"];


    if ($ldap_secured != 1)
    {
        if (!ip2long($ldap_host))
        {
            $ldap_host = gethostbyname($ldap_host);
        }
    }

    $ldap_url = (($ldap_secured == 1) ? "ldaps" : "ldap") . '://' . $ldap_host . ':' . $ldap_port . '/';

    $ds = ldap_connect($ldap_url); //must be a valid LDAP server!
    if ($ds)
    {
        if (ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, $ldap_version))
        {
            //success
        }
        else
        {
            //failed
        }

        $rdn = $confs["domainconf"]["user_dn"];

        // Bind to LDAP server
        $r = ldap_bind($ds, $rdn, $passwd);
        if ((ldap_errno($ds) == -1) && $ldap_host1 != '' && isset($ldap_host1))
        {
            if ($ldap_secured != 1)
            {
                if (!ip2long($ldap_host1))
                {
                    $ldap_host1 = gethostbyname($ldap_host1);
                }
            }
            $ldap_host = $ldap_host1;
            $ldap_url_1 = (($ldap_secured == 1) ? "ldaps" : "ldap") . '://' . $ldap_host1 . ':' . $ldap_port . '/';
            $ds = ldap_connect($ldap_url_1);
            if ($ds)
            {
                if (ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, $ldap_version))
                {
                    //success
                }
            }
            $r = ldap_bind($ds, $rdn, $passwd);
        }

        if (!$r)
        {
            $myLog->log(LOG_ERR, "Failed to bind to LDAP server- " . $ldap_host . ":" . $ldap_port);
            $error_msg = null;
            define(LDAP_OPT_DIAGNOSTIC_MESSAGE, 0x0032);

            if (ldap_get_option($ds, LDAP_OPT_DIAGNOSTIC_MESSAGE, $extended_error))
            {
                if (!empty($extended_error))
                {
                    $errno = explode(',', $extended_error)[2];
                    $errno = explode(' ', $errno)[2];
                    $errno = intval($errno);

                    switch ($errno)
                    {

                        case '525':
                            $error_msg = 'USER NOT FOUND';
                            $auth_failure_detail = 'User not found';
                            break;

                        case '530':
                            $error_msg = 'NOT_PERMITTED_TO_LOGON_AT_THIS_TIME';
                            $auth_failure_detail = 'User not permitted to logon at this time';
                            break;

                        case '531':
                            $error_msg = 'RESTRICTED_TO_SPECIFIC_MACHINES';
                            $auth_failure_detail = 'User not permitted';
                            break;

                        case '532':
                            $error_msg = 'PASSWORD_EXPIRED';
                            $auth_failure_detail = 'Expired password';
                            break;

                        case '533':
                            $error_msg = 'ACCOUNT_DISABLED';
                            $auth_failure_detail = 'Account is disabled of user';
                            break;

                        case '568':
                            $error_msg = 'ERROR_TOO_MANY_CONTEXT_IDS';
                            $auth_failure_detail = 'Too many context IDS';
                            break;

                        case '701':
                            $error_msg = 'ACCOUNT_EXPIRED';
                            $auth_failure_detail = 'Account is expired of user';
                            break;

                        case '773':
                            $error_msg = 'USER MUST RESET PASSWORD';
                            $auth_failure_detail = 'User must reset password';
                            break;
                    }
                }
            }

            if ($error_msg)
            {
                $myLog->log(LOG_DEBUG, "LDAP binding error: " . $error_msg . " (" . $errno . ")");
            }
            else
            {
                $error_msg = ldap_error($ds);
                $errno = ldap_errno($ds);
                $myLog->log(LOG_DEBUG, "LDAP binding error: " . $error_msg . " (" . $errno . ")");
            }
            //check if error_msg is PASSWORD_EXPIRED and 'Allow authentication even if password expires flag' is set to true then return true else
            $pwd_exp = "PASSWORD_EXPIRED";
            $ad_name = "Active Directory";
            if ((strcasecmp($error_msg, $pwd_exp) == 0) && ($allow_auth_if_pwd_exp == 1) && (strcasecmp($directory_name, $ad_name) == 0))
            {
                $myLog->log(LOG_DEBUG, "user's password is expired but allowing authentication since 'Allow authentication even if user's password expired' is set to true");
                $auth_success_detail = "Expired password allowed by GreenRADIUS administrator";
                return true;
            }
            else
            {
                return false;
            }
        }
        else
        {
            $user = $confs["domainconf"]["login_name"];
            $fullusername = $user . "@" . $confs["domainconf"]["domain"];
            ldap_close($ds);
            $myLog->log(LOG_DEBUG, "Successfully bound to LDAP server- " . $ldap_host . ":" . $ldap_port);
            return true;
        }
    }
    else
    {
        //Log authentication
        log_authentication($fullusername, $yubikeyid, '', 0, 'Failed to connect to LDAP server', 0, '', 'AUTH-09--0-2');
        $myLog->log(LOG_ERR, "Failed to connect to LDAP server");
        if ($dirLdapBindTestFlag)
        {
            echo "*Failed!";
        }
        else
        {
            sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
            exit;
        }
    }
}

// STEP#3: Verify the mapping
function verificationOfYkmaping($user, $yubikeyid, $fullusername, $token_type)
{
    global $myLog;
    require_once 'Yubico_YkMap.php';
    global $auth_status;
    global $confs;
    $myLog->log(LOG_DEBUG, 'Found mapping for user- ' . $user . ', YubiKey token id- ' . $yubikeyid);

    global $key_records_found;
    global $check_auto_provisioning;
    {
        $ykmap = &new Auth_Yubico_YkMap($maphttps);
        $ykmap->setURLpart($ykmap_service_url);
        $res = $ykmap->search('yubikey_prefix', $yubikeyid, 'username', '', $token_type);
        if (!$res)
        {
            log_authentication($fullusername, $yubikeyid, 0, 'Token is not assigned to user', 0, '', 227);

            $myLog->log(LOG_ERR, 'Error in searching the YubiKey mapping: ' . $ykmap->getLastResponse());
            logdie($ykmap->getLastResponse());
        }
        else
        {
            if (PEAR::isError($res))
            {
                if ($res->getMessage() == "NO_RECORDS_FOUND")
                {
                    $check_auto_provisioning = 1;
                }
            }
            else
            {
                $matchedusername = $ykmap->parseResponse('username');
                // Search for required username in found mappings
                $matchedusername = array_change_key_case($matchedusername, CASE_LOWER);
                $fullusername = strtolower(urlencode($fullusername));

                if (array_key_exists($fullusername, $matchedusername) === false)
                {
                    $myLog->log(LOG_ERR, 'User-YubiKey Mapping not found' . $res);

                    $key_records_found = 0;
                    if ($res != 1)
                    {
                        $check_auto_provisioning = 1;
                    }
                    else
                    {
                        if ($confs['assign_key_to_multipal_user'])
                        {
                            $check_auto_provisioning = 1;
                        }
                        else
                        {
                            $check_auto_provisioning = 0;
                        }
                    }
                }
                else if ($matchedusername[$fullusername] == 1)
                {
                    $auth_status = 1;
                    if ($service_failed)
                    {
                        $auth_status = ($failed_service == 1) ? 3 : 2;
                    }
                    return true;
                }
            }
        }
    }
}

// STEP#4: Auto provision YubiKey (if no mapping record found)
function AutoProvision($user, $domain, $yubikeyid, $fullusername, $group_info_user = null)
{
    global $myLog;
    global $key_records_found;
    global $auth_status;
    global $check_auto_provisioning;
    global $confs;
    global $auth_success_detail;

    $token_type_license = S_MODULE_ID_YUBIKEY;
    $count_db = getUserMappingsCount("yubikey");
    $response_license = verifyLicenseTokenAdd($token_type_license, $count_db);
    if ($response_license == 0)
    {
        log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'Auto-provisioning failed: reached limit of user-token associations permitted', 0, '', 'AUTH-01-01-0-10');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', Auto-provisioning failed: reached limit of user-token associations permitted');
        exit;
    }
    if ($response_license == -1)
    {
        log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'Auto-provisioning failed: Invalid or expired license', 0, '', 'AUTH-01-01-0-11');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', Auto-provisioning failed: Invalid or expired license');
        exit;
    }

    $max_tokens_per_user_allowed = getSysSettingValue("max_tokens_per_user");
    $records_count = find_no_of_mapping_records_a_user($ykmap_url, $fullusername, "all");
    if ($records_count >= $max_tokens_per_user_allowed)
    {
        $myLog->log(LOG_DEBUG, 'User: ' . $fullusername . ' Token id: ' . $yubikeyid . ' Auto-provisioning of YubiKey token failed: Maximum number number of tokens per user limit reached');
        log_authentication($fullusername, $yubikeyid, 'YubiKey', 0, 'Auto-provisioning failed: user already has maximum number of tokens assigned', 0, '', 'AUTH-01-02-0-17');
        sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
        $myLog->log(LOG_ERR, 'Authentication failed for user- ' . $fullusername . ', Auto-provisioning failed: user already has maximum number of tokens assigned');
        exit;
    }

    if (($check_auto_provisioning == 1) && ($key_records_found == 0))
    {
        if ($confs['auto_provisioning'])
        {
            // Check if YubiKey is already assigned to any user of any domain
            $existing_mapping_record_count = find_no_of_mapping_records_a_user($ykmap_service_url, $fullusername, "yubikey");
            $myLog->log(LOG_DEBUG, 'Auto-provisioning find records: ' . $existing_mapping_record_count);
            if ($existing_mapping_record_count == 0)
            {
                if (!add_mapping_records($ykmap_service_url, $fullusername, $yubikeyid, "yubikey"))
                {
                    $myLog->log(LOG_ERR, 'Auto-provisioning failed: unable to assign a token to a user: ' . $fullusername);
                    log_authentication($fullusername, "", 'YubiKey', 0, "Unable to assign a token to user due to internal error", 0, '', 'AUTH-01-02-0-16');
                    sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                    exit;
                }
                //Log authentication
                $auth_status = 1;
                if ($service_failed)
                {
                    $auth_status = ($failed_service == 1) ? 3 : 2;
                }
                $group_info = fetchGroupInfo($group_info_user, $domain);
                log_authentication($fullusername, $yubikeyid, 'YubiKey', $auth_status, $auth_success_detail, 0, $group_info, 'AUTH-01-02-1-0');
                $myLog->log(LOG_DEBUG, 'Auto-provisioning first key');
                update_user_temp_pass_status($group_info_user, $domain);
                update_gradual_deployment_flag($group_info_user, $domain);

                sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $fullusername));
                $myLog->log(LOG_ERR, 'Authentication successful for user- ' . $fullusername . ', using Auto-provisioning');
                exit;
            }
            else if (($confs['multi_user_auto_provisioning']) && ($existing_mapping_record_count > 0))
            {
                if (!add_mapping_records($ykmap_service_url, $fullusername, $yubikeyid, "yubikey"))
                {
                    $myLog->log(LOG_ERR, 'Auto-provisioning failed: unable to assign a token to user: ' . $fullusername);
                    log_authentication($fullusername, "", 'YubiKey', 0, "Unable to assign a token to user due to internal error", 0, '', 'AUTH-01-02-0-16');
                    sendResp(S_BACKEND_ERROR, $apiKey, $extra, $group_info);
                    exit;
                }

                //Log authentication
                $auth_status = 1;
                if ($service_failed)
                {
                    $auth_status = ($failed_service == 1) ? 3 : 2;
                }

                $group_info = fetchGroupInfo($group_info_user, $domain);
                log_authentication($fullusername, $yubikeyid, 'YubiKey', $auth_status, $auth_success_detail, 0, $group_info, 'AUTH-01-02-1-0');
                update_user_temp_pass_status($group_info_user, $domain);
                update_gradual_deployment_flag($group_info_user, $domain);

                sendResp(S_OK, $apiKey, $extra, $group_info, $confs["domainconf"]["radius_attribute"], '', array('username' => $fullusername));
                $myLog->log(LOG_DEBUG, 'Authentication successful for user- ' . $fullusername . ', using Auto-provisioning of multiple keys');
                exit;
            }
        }
    }
    return false;
}

?>
